"use strict";exports.__esModule=true;exports.default=void 0;var _path=require("path");var _minify=_interopRequireDefault(require("./minify"));var _util=require("util");var _jestWorker=_interopRequireDefault(require("jest-worker"));var _fs=require("fs");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const worker=require.resolve('./minify');const writeFileP=(0,_util.promisify)(_fs.writeFile);const readFileP=(0,_util.promisify)(_fs.readFile);class TaskRunner{constructor({distDir,cpus,cache,workerThreads}){if(cache){(0,_fs.mkdirSync)(this.cacheDir=(0,_path.join)(distDir,'cache','next-minifier'),{recursive:true});}// In some cases cpus() returns undefined
// https://github.com/nodejs/node/issues/19022
this.maxConcurrentWorkers=cpus;this.useWorkerThreads=workerThreads;}run(tasks,callback){/* istanbul ignore if */if(!tasks.length){callback(null,[]);return;}if(this.maxConcurrentWorkers>1){this.workers=new _jestWorker.default(worker,{enableWorkerThreads:this.useWorkerThreads,numWorkers:this.maxConcurrentWorkers});this.boundWorkers=options=>this.workers.default(options);}else{this.boundWorkers=async options=>(0,_minify.default)(options);}let toRun=tasks.length;const results=[];const step=(index,data)=>{toRun-=1;results[index]=data;if(!toRun){callback(null,results);}};tasks.forEach((task,index)=>{const cachePath=this.cacheDir&&(0,_path.join)(this.cacheDir,task.cacheKey);const enqueue=async()=>{try{const result=await this.boundWorkers(task);const done=()=>step(index,result);if(cachePath){writeFileP(cachePath,JSON.stringify(result),'utf8').then(done).catch(done);}}catch(error){step(index,{error});}};if(this.cacheDir){readFileP(cachePath,'utf8').then(data=>step(index,JSON.parse(data))).catch(()=>enqueue());}else{enqueue();}});}exit(){if(this.workers){this.workers.end();}}}exports.default=TaskRunner;