"use strict";exports.__esModule=true;exports.loadEnvConfig=loadEnvConfig;var _fs=_interopRequireDefault(require("fs"));var _path=_interopRequireDefault(require("path"));var _chalk=_interopRequireDefault(require("next/dist/compiled/chalk"));var _findUp=_interopRequireDefault(require("next/dist/compiled/find-up"));var _dotenvExpand=_interopRequireDefault(require("next/dist/compiled/dotenv-expand"));var _dotenv=_interopRequireDefault(require("next/dist/compiled/dotenv"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const packageJsonHasDep=(packageJsonPath,dep)=>{const{dependencies,devDependencies}=require(packageJsonPath);const allPackages=Object.keys({...dependencies,...devDependencies});return allPackages.some(pkg=>pkg===dep);};function loadEnvConfig(dir,dev){const packageJson=_findUp.default.sync('package.json',{cwd:dir});// only do new env loading if dotenv isn't installed since we
// can't check for an experimental flag in next.config.js
// since we want to load the env before loading next.config.js
if(packageJson){// check main `package.json` first
if(packageJsonHasDep(packageJson,'dotenv')){return false;}// check for a yarn.lock or lerna.json file in case it's a monorepo
const monorepoFile=_findUp.default.sync(['yarn.lock','lerna.json','package-lock.json'],{cwd:dir});if(monorepoFile){const monorepoRoot=_path.default.dirname(monorepoFile);const monorepoPackageJson=_path.default.join(monorepoRoot,'package.json');try{if(packageJsonHasDep(monorepoPackageJson,'dotenv')){return false;}}catch(_){}}}else{// we should always have a package.json but disable in case we don't
return false;}const isTest=process.env.NODE_ENV==='test';const mode=isTest?'test':dev?'development':'production';const dotenvFiles=[`.env.${mode}.local`,`.env.${mode}`,// Don't include `.env.local` for `test` environment
// since normally you expect tests to produce the same
// results for everyone
mode!=='test'&&`.env.local`,'.env'].filter(Boolean);const combinedEnv={...process.env};for(const envFile of dotenvFiles){// only load .env if the user provided has an env config file
const dotEnvPath=_path.default.join(dir,envFile);try{const stats=_fs.default.statSync(dotEnvPath);// make sure to only attempt to read files
if(!stats.isFile()){continue;}const contents=_fs.default.readFileSync(dotEnvPath,'utf8');let result={};result.parsed=_dotenv.default.parse(contents);result=(0,_dotenvExpand.default)(result);if(result.parsed){console.log(`> ${_chalk.default.cyan.bold('Info:')} Loaded env from ${envFile}`);}Object.assign(combinedEnv,result.parsed);}catch(err){if(err.code!=='ENOENT'){console.error(`> ${_chalk.default.cyan.bold('Error: ')} Failed to load env from ${envFile}`,err);}}}// load global env values prefixed with `NEXT_PUBLIC_` to process.env
for(const key of Object.keys(combinedEnv)){if(key.startsWith('NEXT_PUBLIC_')&&typeof process.env[key]==='undefined'){process.env[key]=combinedEnv[key];}}return combinedEnv;}