"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
function normalizePagePath(page) {
    // If the page is `/` we need to append `/index`, otherwise the returned directory root will be bundles instead of pages
    if (page === '/') {
        page = '/index';
    }
    // Resolve on anything that doesn't start with `/`
    if (page[0] !== '/') {
        page = `/${page}`;
    }
    // Throw when using ../ etc in the pathname
    const resolvedPage = path_1.posix.normalize(page);
    if (page !== resolvedPage) {
        throw new Error(`Requested and resolved page mismatch: ${page} ${resolvedPage}`);
    }
    return page;
}
exports.normalizePagePath = normalizePagePath;
