"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const etag_1 = __importDefault(require("next/dist/compiled/etag"));
const fresh_1 = __importDefault(require("next/dist/compiled/fresh"));
const utils_1 = require("../lib/utils");
function sendHTML(req, res, html, { generateEtags, poweredByHeader, }) {
    if (utils_1.isResSent(res))
        return;
    const etag = generateEtags ? etag_1.default(html) : undefined;
    if (poweredByHeader) {
        res.setHeader('X-Powered-By', 'Next.js');
    }
    if (fresh_1.default(req.headers, { etag })) {
        res.statusCode = 304;
        res.end();
        return;
    }
    if (etag) {
        res.setHeader('ETag', etag);
    }
    if (!res.getHeader('Content-Type')) {
        res.setHeader('Content-Type', 'text/html; charset=utf-8');
    }
    res.setHeader('Content-Length', Buffer.byteLength(html));
    res.end(req.method === 'HEAD' ? null : html);
}
exports.sendHTML = sendHTML;
